(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     41339,       1303]*)
(*NotebookOutlinePosition[     61878,       1745]*)
(*  CellTagsIndexPosition[     60881,       1716]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Evaluation ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell[CellGroupData[{

Cell["Evaluate Cells", "Command",
  CellTags->"EvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate Cells", "SR"],
  " sends the currently selected cells to the kernel for evaluation."
}], "Usage",
  CellTags->"EvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] Only cells with the option ",
  StyleBox["Evaluatable\[Rule]True", "MR"],
  " (normally cells in the Input style) will be evaluated: All other cells \
will be ignored.\n\[FilledSmallSquare] If you do not currently have the \
appropriate kernel running, it will be started for you (see the Default \
Kernel and Notebooks Kernel submenus).\n\[FilledSmallSquare] A cell may have \
a private kernel specified (see the Evaluator option), in which the cells you \
evaluate may be sent to different kernels.  The output from multiple kernels \
will be placed after the corresponding input cells as soon as it is received. \
 This means output from lower cells may be placed before output from higher \
cells."
}], "Notes",
  CellTags->"EvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:",
  StyleBox[" \[ShiftKey]\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ReturnKey] ", "C1"],
  StyleBox["or ", "Notes"],
  StyleBox["\[EnterKey]", "C1MR"],
  StyleBox[" ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ReturnKey]", "C1"],
  StyleBox[" or", "Notes"],
  StyleBox[" \[EnterKey] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"EvaluateCells"]
}, Open  ]],

Cell[TextData[
"\[FilledSmallSquare] Pressing \[ReturnKey] by itself does not evaluate a \
selection--it produces a line break."], "Notes",
  CellTags->"EvaluateCells"],

Cell[CellGroupData[{

Cell["Evaluate In Place", "Command",
  CellTags->"Evaluate"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate In Place", "SR"],
  " evaluates the current selection in place."
}], "Usage",
  CellTags->"Evaluate"],

Cell[TextData[{
  "\[FilledSmallSquare] No new output cell is produced,  instead the output \
is pasted over the selected input.\n\[FilledSmallSquare] Unlike ",
  StyleBox["Evaluate Cells", "SR"],
  ",",
  StyleBox[" Evaluate In Place", "SR"],
  " evaluates only the selected characters, not the whole cell.\n\
\[FilledSmallSquare] If the evaluation produces warning messages, ",
  StyleBox["print", "MR"],
  " output, or graphics output, all are placed in new cells below the cell \
being evaluated."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Evaluate"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[KeyBar]\[ReturnKey] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[KeyBar]\[ReturnKey] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Evaluate"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evaluate Next Input", "Command",
  CellTags->"EvaluateNextCell"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate Next Input", "SR"],
  " selects and then evaluates the next cell in the notebook."
}], "Usage",
  CellTags->"EvaluateNextCell"],

Cell[TextData[
"\[FilledSmallSquare] This command moves to and then evaluates the next input \
cell below the current selection. When the current selection is a single \
input cell, it is evaluated; otherwise, the next input cell after the current \
selection is selected. By repeatedly choosing this command, you can evaluate \
all the input cells in a notebook, one at a time. "], "Notes",
  CellTags->"EvaluateNextCell"],

Cell[TextData[
"\[FilledSmallSquare] You need to choose this command twice for each cell, \
once to select it and once to evaluate it. This allows you to see the next \
input before evaluating it, and is good for pre-programmed demonstrations."], 
  "Notes",
  CellTags->"EvaluateNextCell"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]Keypad\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[EnterKey]  ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"EvaluateNextCell"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evaluate in Subsession", "Command",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate in Subsession", "SR"],
  " evaluates the selected cells in a kernel dialog."
}], "Usage",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] When an evaluation is in progress, you can use this \
command to inspect the state of the kernel. When you select ",
  StyleBox["Evaluate in Subsession", "SR"],
  ", the current evaluation is suspended (indicated by a grayed cell \
bracket), the cells selected are evaluated in a kernel subsession (",
  StyleBox["Dialog", "Input"],
  "), and then the original evaluation is resumed."
}], "Notes",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[
"\[FilledSmallSquare] This can be useful for checking on the status of \
variables in a long calculation, or for debugging."], "Notes",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["Dialog",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["F7 ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[OptionKey]\[KeyBar]\[ReturnKey]  ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[Mod2Key]-\[ReturnKey] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SubsessionEvaluateCell"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evaluate Notebook", "Command",
  CellTags->"EvaluateNotebook"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate Notebook", "SR"],
  " evaluates all the evaluatable cells in the notebook."
}], "Usage",
  CellTags->"EvaluateNotebook"],

Cell[TextData[
"\[FilledSmallSquare] This is useful for notebooks in which each cell depends \
on the ones above, and all need to be re-evaluated to get the final result."],
   "Notes",
  CellTags->"EvaluateNotebook"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evaluate Initialization", "Command",
  CellTags->"EvaluateInitialization"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate Initialization", "SR"],
  " evaluates all initialization cells in the notebook."
}], "Usage",
  CellTags->"EvaluateInitialization"],

Cell[TextData[{
  "\[FilledSmallSquare] All cells with the options ",
  StyleBox["Evaluatable\[Rule]True", "MR"],
  " and ",
  StyleBox["InitializationCell\[Rule]True", "MR"],
  " will be evaluated.  Normally notebooks are set up so that these cells \
contain definitions needed to use other material in the notebook."
}], "Notes",
  CellTags->"EvaluateInitialization"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Enter Subsession", "Command",
  CellTags->"EnterSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Enter Subsession", "SR"],
  " enters an interactive subsession (Dialog) during an evalution."
}], "Usage",
  CellTags->"EnterSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["Dialog",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"EnterSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book:  ",
  ButtonBox["Section 2.13.2",
    ButtonData:>{"2.13.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"EnterSubsession"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exit Subsession", "Command",
  CellTags->"ExitSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Exit Subsession", "SR"],
  " exits the interactive subsession."
}], "Usage",
  CellTags->"ExitSubsession"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remove From Evaluation Queue", "Command",
  CellTags->"RemoveFromEvaluationQueue"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Remove From Evaluation Queue", "SR"],
  " cancels the pending evaluation of the selected cell."
}], "Usage",
  CellTags->"RemoveFromEvaluationQueue"],

Cell[TextData[{
  "\[FilledSmallSquare] When you select several cells and choose ",
  StyleBox["Evaluate Cells", "SR"],
  ", the selected cell brackets are outlined, indicating that they are being \
sent  one by one to the kernel for evaluation."
}], "Notes",
  CellTags->"RemoveFromEvaluationQueue"],

Cell[TextData[
"\[FilledSmallSquare] By choosing this command, you can prevent a cell from \
being evaluated before its turn comes up."], "Notes",
  CellTags->"RemoveFromEvaluationQueue"],

Cell[TextData[{
  "\[FilledSmallSquare] To stop the evaluation of a cell that is currently \
being evaluated, use",
  StyleBox[" ", "SR",
    FontWeight->"Bold"],
  StyleBox["Interrupt Evaluation", "SR"],
  " or ",
  StyleBox["Abort Evaluation", "SR"],
  "."
}], "Notes",
  CellTags->"RemoveFromEvaluationQueue"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interrupt Evaluation...", "Command",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Interrupt Evaluation ", "SR"],
  " interrupts the current operation being performed by the kernel."
}], "Usage",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] This dialog box appears when you choose ",
  StyleBox["Interrupt Evaluation", "SR"],
  " from the Kernel menu during an evaluation. You can use this dialog box to \
abort an evaluation, or to examine its progress. If you click Continue \
Evaluation, your evaluation completes normally."
}], "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[AltKey]\[LeftModified] , ] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified] , ] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified] , \[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"EvaluatorInterrupt"],

Cell[TextData[StyleBox["Continue Evaluation",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell["\<\
Closes the dialog box and lets your calculation proceed normally.\
\
\>", "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell["Abort Command Being Evaluated", "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "Aborts the calculation. (This button is equivalent to the ",
  StyleBox["Abort Evaluation", "SR"],
  " command in the Kernel menu.) If you click Abort, your calculation is \
stopped. The result entered in the notebook is a symbol, ",
  StyleBox["$Aborted", "MR",
    FontFamily->"Courier"],
  ", representing an interrupted calculation. "
}], "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[StyleBox["Enter Subsession",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "Initiates a ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " dialog within the interrupted calculation. (This button is equivalent to \
the ",
  StyleBox["Enter Subsession", "SR"],
  " command in the Evaluation submenu.)"
}], "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "See Reference Guide: ",
  ButtonBox["Dialog",
    ButtonStyle->"RefGuideLink"],
  "."
}], "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "See the ",
  StyleBox["Mathematica", "TI"],
  " book:  ",
  ButtonBox["Section 2.13.2",
    ButtonData:>{"2.13.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "Some calculations may not be immediately interruptible, in which case you \
do not get the dialog box until the calculation is able to stop. Sometimes \
when using a remote kernel you may not be able to interrupt short \
calculations at all, because they are finished before the interrupt request \
can be transmitted over the network."
}], "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "When you have more than one kernel running at the same time (",
  StyleBox["e.g.",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ", a local kernel and a remote kernel), this command applies only to the \
\"current\" kernel. You can have several interrupt dialog boxes visible at \
the same time, each labeled with the name of the corresponding kernel."
}], "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "If ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " is communicating with another program via ",
  StyleBox["MathLink",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ", the \"",
  StyleBox["MathLink",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  "  Control\" options allow you to interrupt, abort, or kill the linked \
program."
}], "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] If Abort does not work (",
  StyleBox["i.e.",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ", if the calculation still keeps running for more than a few seconds), you \
can choose ",
  StyleBox["Quit Kernel", "SR"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "from the Kernel menu. If you do this, you will have to restart a kernel \
before you can evaluate anything else."
}], "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Abort Evaluation", "Command",
  CellTags->"EvaluatorAbort"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Abort Evaluation", "SR"],
  " aborts the current evaluation."
}], "Usage",
  CellTags->"EvaluatorAbort"],

Cell[TextData[
"\[FilledSmallSquare] This command has the same function as clicking the \
Abort button in the Interrupt dialog box."], "Notes",
  CellTags->"EvaluatorAbort"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Interrupt Evaluation",
    ButtonStyle->"OtherResourcesLink"],
  "."
}], "Notes",
  CellTags->"EvaluatorAbort"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[AltKey]\[LeftModified] . ] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified] . ] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified] . \[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"EvaluatorAbort"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Start Kernel", "Command",
  CellTags->"MenuListStartEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Start Kernel", "SR"],
  " starts the specified kernel."
}], "Usage",
  CellTags->"MenuListStartEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] Kernel connections are defined in the ",
  StyleBox["Kernel Configuration Options", "SR"],
  " dialog box. Once you have defined a kernel connection in this dialog box, \
the name you gave it appears in this menu."
}], "Notes",
  CellTags->"MenuListStartEvaluators"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quit Kernel", "Command",
  CellTags->"MenuListQuitEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Quit Kernel", "SR"],
  " terminates the specified kernel."
}], "Usage",
  CellTags->"MenuListQuitEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] Kernel connections are defined in the ",
  StyleBox["Kernel Configuration Options", "SR"],
  " dialog box. Once you have defined a kernel connection in this dialog box, \
the name you gave it appears in this menu."
}], "Notes",
  CellTags->"MenuListQuitEvaluators"],

Cell[TextData[
"\[FilledSmallSquare] Active kernels have a check mark beside their name."], 
  "Notes",
  CellTags->"MenuListQuitEvaluators"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Quit Local Kernel dialog box",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False],

Cell[TextData[
"\[FilledSmallSquare] This dialog box is just a warning that you are about to \
lose all the information contained in your local kernel."], "Usage",
  AspectRatioFixed->False]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Quit Remote Kernel dialog box",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False],

Cell[TextData[{
  "\[FilledSmallSquare] This dialog box is just a warning that the ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " front end is about to transmit a Quit signal to the remote kernel."
}], "Usage",
  AspectRatioFixed->False]
}, Open  ]],

Cell[CellGroupData[{

Cell["Default Kernel", "Command",
  CellTags->"MenuListGlobalEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Kernel", "SR"],
  " specifies the kernel to be used by default for all calculations."
}], "Usage",
  CellTags->"MenuListGlobalEvaluators"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Notebook\[CloseCurlyQuote]s Kernel"], "Command",
  CellTags->"MenuListNotebookEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Notebook's Kernel", "SR"],
  " specifies the kernel to be used for the current notebook."
}], "Usage",
  CellTags->"MenuListNotebookEvaluators"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Open Terminal Window", "Command",
  CellTags->"MenuListTerminals"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open Terminal Window", "SR"],
  " opens a terminal onto the host for the specified remote kernel."
}], "Usage",
  CellTags->"MenuListTerminals"],

Cell[TextData[
"\[FilledSmallSquare] If any remote kernel configurations have been defined \
they will appear in this submenu. \n\[FilledSmallSquare] The terminal window \
acts as a simple shell window that you can use to inspect the state of the \
computer on which your remote kernel is running."], "Notes",
  CellTags->"MenuListTerminals"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Kernel Configuration Options...", "Command",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Kernel Configuration Options", "SR"],
  " lets you set up connections to a kernel. "
}], "Usage",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[
"\[FilledSmallSquare] When \"Append name to In/Out prompts\" is checked, the \
name of the kernel connection is appended to cell labels generated during \
that connection."], "Notes",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[
"\[FilledSmallSquare] The kernel names that you define here are shown \
throughout the front end whenever you have a choice of kernels."], "Notes",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[CellGroupData[{

Cell["Defining Kernel Connections: General Instructions", "SubsectionIcon",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "When you choose ",
  StyleBox["Kernel Configuration Options", "SR"],
  " from the Kernel menu, a dialog box lists the kernel connections already \
defined. \"Local\" is the default connection to MathKernel on your local \
machine."
}], "Notes",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "To define a new kernel:"
}], "Notes",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  " Choose ",
  StyleBox["Kernel Configuration Options", "SR"],
  "\n",
  StyleBox["2.",
    FontWeight->"Bold"],
  " Click Add. The configuration dialog box will open to let you define the \
new connection\n",
  StyleBox["3.",
    FontWeight->"Bold"],
  " Fill in the Kernel Name\n",
  StyleBox["4.",
    FontWeight->"Bold"],
  " Choose whether to launch the kernel on the local computer or on a remote \
computer\n",
  StyleBox["5.",
    FontWeight->"Bold"],
  " Give the name of the Kernel Program. On Macintosh or Microsoft Windows, \
the name is typically \"MathKernel\". On Unix systems the name is typically \
\"math\", which is the shell script that runs MathKernel.\n",
  StyleBox["6.",
    FontWeight->"Bold"],
  " Click OK to save the kernel connection."
}], "ItemizedText",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remote Kernel Connections: Microsoft Windows", "SubsectionIcon",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "To set up a connection from a Windows front end to a kernel on a remote \
machine:"
}], "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  "  Choose Kernel Configurations Options in the Kernel menu.\n",
  StyleBox["2.",
    FontWeight->"Bold"],
  "  In the dialog box that appears, click Add.\n",
  StyleBox["3.",
    FontWeight->"Bold"],
  "  Fill out the connection name, which will be the name given in the list \
of available kernels.\n",
  StyleBox["4.  ",
    FontWeight->"Bold"],
  "Specify that the kernel is on a remote machine.\n",
  StyleBox["5.  ",
    FontWeight->"Bold"],
  "Give the hostname of the remote machine. \n",
  StyleBox["6.",
    FontWeight->"Bold"],
  "  Type your user name for the remote machine.\n",
  StyleBox["7.  ",
    FontWeight->"Bold"],
  "Click OK."
}], "ItemizedText",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  "To use the new kernel, go to the Kernel menu and select the new kernel \
from either the ",
  StyleBox["Start Kernel", "Notes"],
  ", Default Kernel, or Notebook\[CloseCurlyQuote]s Kernel submenu. The front \
end included in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 3 must be connected to a Version 2.2 or 3 kernel."
}], "NotesList",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[CellGroupData[{

Cell["Permission denied", "Subsubsection",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] If you followed the preceding instructions and \
received a warning such as \"Permission denied\", the remote machine has not \
accepted you as a valid user. Try the following procedure, \"Remote kernel \
setup on a non-trusted host,\" or contact your network administrator for \
help.\n\[FilledSmallSquare] If a kernel connection fails to start up \
correctly, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end will treat that connection as idle. If you wish to try opening \
the connection again, you should first go to the Kernels menu, point to Quit \
Kernel, and select the name of the idle connection to close it."
}], "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remote kernel setup on a non-trusted host", "Subsubsection",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "If the remote computer does not consider your computer a \"trusted host,\" \
you should change the remote kernel configuration to request your password \
for the remote computer upon kernel startup. "
}], "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "To modify a remote kernel configuration to require entry of a password:"
}], "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  StyleBox["1. ",
    FontWeight->"Bold"],
  " In the Kernel Properties dialog for a remote kernel (set up according to \
the previous instructions), check the box labeled \"Request password when \
connecting\".\n",
  StyleBox["2.  ",
    FontWeight->"Bold"],
  "Click OK."
}], "ItemizedText",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell["\<\
You will now need to enter a password whenever you try to start \
this remote kernel.\
\>", "NotesList",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "To use a remote kernel that requests a password:"
}], "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  "  Select the remote kernel from either the Start Kernel, Default Kernel, \
or Notebook's Kernel submenu. \n",
  StyleBox["2.",
    FontWeight->"Bold"],
  "  If you have selected the remote kernel as the default kernel or as the \
current notebook's kernel, launch it by entering an expression and pressing \
\[ShiftKey]\[KeyBar]\[EnterKey].\n    As the remote kernel is started up, a \
\"Remote kernel\" task will appear in your computer\[CloseCurlyQuote]s task \
bar, and a Remote Login dialog box will pop up.\n",
  StyleBox["4.",
    FontWeight->"Bold"],
  "  Enter your password for the remote computer in the Password field dialog \
that appears on your screen.\n",
  StyleBox["5.",
    FontWeight->"Bold"],
  "  Click Connect."
}], "ItemizedText",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Remote Kernel Connections: Macintosh", "SubsectionIcon",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[CellGroupData[{

Cell["Connecting from a Macintosh Front End to a Unix Kernel ", 
  "Subsubsection",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "To establish a remote connection to a Unix kernel the kernel must be \
Version 2.2 or later. "
}], "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "Connecting to a remote Unix kernel via ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " takes place in two steps. First, the front end prepares itself for an \
incoming connection, opens a terminal window to the Unix host, and logs onto \
the remote host (either manually or automatically). Second, the front end \
uses a terminal window to command the Unix host to launch a kernel and \
connect back to the front end. Once this second step is complete, the \
terminal connection is closed."
}], "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "To define a connection to a remote Unix kernel under the TCP/IP \
communications protocol:"
}], "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  StyleBox["1. ",
    FontWeight->"Bold"],
  " Make sure you have MacTCP installed and configured correctly for your \
Macintosh.\n",
  StyleBox["2. ",
    FontWeight->"Bold"],
  " Make sure the VersaTerm Telnet Tool is in the appropriate location in the \
System Folder. (Dragging the icon to the System Folder will ensure its proper \
placement automatically.)\n",
  StyleBox["3.",
    FontWeight->"Bold"],
  "  Make sure you have a Terminal Tool (e.g., TTY Tool or VT100 Tool) in the \
appropriate location in the System Folder.\n",
  StyleBox["4.",
    FontWeight->"Bold"],
  "  Select Kernel Configuration Options from the Kernel menu. This brings up \
a dialog box.\n",
  StyleBox["5.",
    FontWeight->"Bold"],
  "  Click the New Kernel button. The Kernel Configuration dialog box appears \
to let you define a kernel connection.\n",
  StyleBox["6.",
    FontWeight->"Bold"],
  "  Type a name for the new connection in the text box.\n",
  StyleBox["7.",
    FontWeight->"Bold"],
  "  Click the Connection type radio button labeled MathLink.\n",
  StyleBox["8.",
    FontWeight->"Bold"],
  "  Click the \"Launch on\" radio button labeled \"Remote Machine\".\n",
  StyleBox["9.",
    FontWeight->"Bold"],
  "  Make sure that the Kernel program text box reads \"math\".\n",
  StyleBox["10.",
    FontWeight->"Bold"],
  " Edit the login string in the Remote Login text box. (See ",
  ButtonBox["Entering a Login String",
    ButtonData:>"enteringloginstring",
    ButtonStyle->"Hyperlink"],
  ", below.)\n",
  StyleBox["11.",
    FontWeight->"Bold"],
  " Click the Connection button. A Connection Settings dialog box appears.\n",
  
  StyleBox["12.",
    FontWeight->"Bold"],
  " Select VersaTerm Telnet Tool from the pop-up menu a the top of the dialog \
box.\n",
  StyleBox["13.",
    FontWeight->"Bold"],
  " In the text box, type the name or IP address of the Unix host on which \
the kernel will run. For more information, see the documentation for the \
VersaTerm Telnet Tool.\n",
  StyleBox["14.",
    FontWeight->"Bold"],
  " Click OK to activate the selected communications settings. The \
Communications Settings dialog box disappears and you are returned to the \
Kernel Configuration dialogbox.\n",
  StyleBox["15.",
    FontWeight->"Bold"],
  " Click the Terminal button. A Terminal Settings dialog box appears that \
lets you specify what kind of terminal emulation your Macintosh will use when \
communicating with the remote computer.\n",
  StyleBox["16.",
    FontWeight->"Bold"],
  " Select the desired terminal emulation and specify any options you want in \
the dialog box. For more information, see the documentation for the Terminal \
Tool.\n",
  StyleBox["17. ",
    FontWeight->"Bold"],
  "Click OK to activate the selected terminal settings. The Terminal Settings \
dialog box disappears and you are returned to the Kernel Configuration dialog \
box.\n",
  StyleBox["18.",
    FontWeight->"Bold"],
  " Click OK to save the kernel connection. The Kernel Configuration dialog \
box disappears and you are returned to the list of kernel connections. If you \
are done, click OK again."
}], "ItemizedText",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[CellGroupData[{

Cell["Entering a Login String", "Subsubsection",
  CellTags->{
  "enteringloginstring", "kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "The \"login string\" lets the remote kernel start automatically so you \
don't have to enter your login every time you start the remote kernel.A \
typical login string for a remote Unix computer looks like this:"
}], "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  StyleBox["^:", "MR"],
  StyleBox["username", "MR",
    FontSlant->"Italic"],
  StyleBox["\\r^:", "MR"],
  StyleBox["password", "MR",
    FontSlant->"Italic"],
  StyleBox["\\r^>", "MR"]
}], "NotesList",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "The characters in this login string are interpreted by the front end as \
follows."
}], "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Characters",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(^ : \),
                "MR"], 
              
              StyleBox[
                \(wait\ for\ the\ remote\ computer\ to\ send\ a\ colon\),
                FontFamily->"Helvetica",
                FontSize->10]},
            {
              RowBox[{
                StyleBox["username",
                  FontSlant->"Italic"], "\\r"}], 
              
              StyleBox[
                \(send\ the\ login\ name\ followed\ by\ a\ carriage\ return\),
                
                FontFamily->"Helvetica",
                FontSize->10]},
            {
              RowBox[{
                StyleBox["password",
                  FontSlant->"Italic"], "\\r"}], 
              
              StyleBox[
                \(send\ the\ password\ \ followed\ by\ a\ carriage\ return\),
                FontFamily->"Helvetica",
                FontSize->10]},
            {\(^ > \), 
              
              StyleBox[
                \(wait\ for\ the\ remote\ compute\ to\ send\ a\ command\ line
                  \ prompt\),
                FontFamily->"Helvetica",
                FontSize->10]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "On typical Unix systems,  the colon (",
  StyleBox[":", "MR"],
  ") ends the Unix login prompts ",
  StyleBox["login:", "MR"],
  " and ",
  StyleBox["password:", "MR"],
  "and the \"greater than\"  character (>) is the command-line prompt. You \
might need to make changes as appropriate for your particular system."
}], "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "The terms ",
  StyleBox["username", "MR",
    FontSlant->"Italic"],
  " and ",
  StyleBox["password", "MR",
    FontSlant->"Italic"],
  " should be replaced by your login name and password for the remote \
computer."
}], "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "Omitting portions (or all) of the login string requires you to enter the \
corresponding text each time you start the remote kernel. The login string ",
  StyleBox["^:", "MR"],
  StyleBox["username", "MR",
    FontSlant->"Italic"],
  StyleBox["\\r^:^>", "MR"],
  ", for example,  omits the password, requiring you to enter it each time \
the remote kernel is started. "
}], "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Connecting from a Macintosh Front End to a Kernel on Another Macintosh\
\>", "Subsubsection",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can connect the Macintosh front end to one or more kernels on remote \
Macintosh computers on the same network. To make such a connection, program \
linking must be enabled on the remote machine.\n\[FilledSmallSquare] ",
  "If guests are not allowed to link programs, a user password will have to \
be entered before the link can be made."
}], "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[
"\[FilledSmallSquare] To set up a connection to a kernel on another \
Macintosh:"], "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  " Run MathKernel on the remote Macintosh.\n",
  StyleBox["2.",
    FontWeight->"Bold"],
  " At the ",
  StyleBox["In[1]:=",
    FontSlant->"Italic"],
  " prompt, enter the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " command ",
  StyleBox["$ParentLink=LinkOpen[LinkMode->Listen]", "MR"],
  "\n",
  StyleBox["3.",
    FontWeight->"Bold"],
  " Launch the front end on the local Macintosh.\n",
  StyleBox["4.",
    FontWeight->"Bold"],
  " Choose ",
  StyleBox["Kernel Configuration Options", "MR"],
  " in the Kernel menu.A dialog box appears listing the names of kernel \
connections.\n",
  StyleBox["5.",
    FontWeight->"Bold"],
  " Click the New Kernel button. The Kernel Configuration dialog box appears \
to let you define a kernel connection.\n",
  StyleBox["6.",
    FontWeight->"Bold"],
  " Click the Advanced Options radio button.\n",
  StyleBox["7.",
    FontWeight->"Bold"],
  " Enter ",
  StyleBox["-LinkMode Connect", "MR"],
  " in the Arguments to MLOpen text box. (Delete any other options in this \
text box.)\n",
  StyleBox["8.",
    FontWeight->"Bold"],
  " Delete the text in the Communications Toolbox Login text box. (This login \
string is intended for remote Unix connections.)\n",
  StyleBox["9.",
    FontWeight->"Bold"],
  " Click OK to save the kernel connection.\n",
  StyleBox["10.",
    FontWeight->"Bold"],
  " Launch the new kernel by choosing it in the Start Kernel submenu of the \
Kernel menu. A program communication browser should appear.\n",
  StyleBox["11.",
    FontWeight->"Bold"],
  " Click the zone of the remote Macintosh; click the computer's name; click \
the kernel name; then click the OK button."
}], "ItemizedText",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Edit List", "Command",
  CellTags->"propertiesDialogID"],

Cell["\<\
This dialog box is displayed when you need to select an item from a \
list to be edited. \
\>", "Usage",
  CellTags->"propertiesDialogID"],

Cell[TextData[
"\[FilledSmallSquare] Click the item in the list box to select it."], "Notes",\

  CellTags->"propertiesDialogID"],

Cell["Add", "DialogItem",
  CellTags->"propertiesDialogID"],

Cell["Lets you add a new item to the list.", "IndentedText",
  CellTags->"propertiesDialogID"],

Cell["Remove", "DialogItem",
  CellTags->"propertiesDialogID"],

Cell["Deletes an item from the list.", "IndentedText",
  CellTags->"propertiesDialogID"],

Cell["Edit ", "DialogItem",
  CellTags->"propertiesDialogID"],

Cell["Lets you modify the selected item.", "IndentedText",
  CellTags->"propertiesDialogID"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show In/Out Names", "Command",
  CellTags->"ShowCellLabel"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show In/Out Names", "SR"],
  " toggles display of ",
  StyleBox["CellLabels", "MR"],
  "."
}], "Usage",
  CellTags->"ShowCellLabel"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Delete All Output", "Command",
  CellTags->"DeleteGeneratedCells"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Delete All Output", "SR"],
  " deletes all cells in the current notebook that have been produced as \
output by the kernel."
}], "Usage",
  CellTags->"DeleteGeneratedCells"]
}, Open  ]]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
CellGrouping->Manual,
WindowSize->{461, 278},
WindowMargins->{{Automatic, 109}, {Automatic, 14}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "EvaluateCells"->{
    Cell[1850, 59, 62, 1, 34, "Command",
      CellTags->"EvaluateCells"],
    Cell[1915, 62, 190, 5, 29, "Usage",
      CellTags->"EvaluateCells"],
    Cell[2108, 69, 784, 13, 132, "Notes",
      CellTags->"EvaluateCells"],
    Cell[2895, 84, 564, 17, 36, "Notes",
      CellTags->"EvaluateCells"],
    Cell[3474, 104, 168, 3, 22, "Notes",
      CellTags->"EvaluateCells"]},
  "Evaluate"->{
    Cell[3667, 111, 60, 1, 34, "Command",
      CellTags->"Evaluate"],
    Cell[3730, 114, 165, 5, 29, "Usage",
      CellTags->"Evaluate"],
    Cell[3898, 121, 565, 13, 76, "Notes",
      CellTags->"Evaluate"],
    Cell[4466, 136, 434, 12, 70, "Notes",
      CellTags->"Evaluate"]},
  "EvaluateNextCell"->{
    Cell[4937, 153, 70, 1, 70, "Command",
      CellTags->"EvaluateNextCell"],
    Cell[5010, 156, 191, 5, 70, "Usage",
      CellTags->"EvaluateNextCell"],
    Cell[5204, 163, 423, 6, 70, "Notes",
      CellTags->"EvaluateNextCell"],
    Cell[5630, 171, 290, 5, 70, "Notes",
      CellTags->"EvaluateNextCell"],
    Cell[5923, 178, 433, 12, 70, "Notes",
      CellTags->"EvaluateNextCell"]},
  "SubsessionEvaluateCells"->{
    Cell[6393, 195, 80, 1, 70, "Command",
      CellTags->"SubsessionEvaluateCells"],
    Cell[6476, 198, 192, 5, 70, "Usage",
      CellTags->"SubsessionEvaluateCells"],
    Cell[6671, 205, 476, 9, 70, "Notes",
      CellTags->"SubsessionEvaluateCells"],
    Cell[7150, 216, 189, 3, 70, "Notes",
      CellTags->"SubsessionEvaluateCells"],
    Cell[7342, 221, 177, 6, 70, "Notes",
      CellTags->"SubsessionEvaluateCells"]},
  "SubsessionEvaluateCell"->{
    Cell[7522, 229, 429, 12, 70, "Notes",
      CellTags->"SubsessionEvaluateCell"]},
  "EvaluateNotebook"->{
    Cell[7988, 246, 68, 1, 70, "Command",
      CellTags->"EvaluateNotebook"],
    Cell[8059, 249, 184, 5, 70, "Usage",
      CellTags->"EvaluateNotebook"],
    Cell[8246, 256, 217, 4, 70, "Notes",
      CellTags->"EvaluateNotebook"]},
  "EvaluateInitialization"->{
    Cell[8500, 265, 80, 1, 70, "Command",
      CellTags->"EvaluateInitialization"],
    Cell[8583, 268, 195, 5, 70, "Usage",
      CellTags->"EvaluateInitialization"],
    Cell[8781, 275, 369, 8, 70, "Notes",
      CellTags->"EvaluateInitialization"]},
  "EnterSubsession"->{
    Cell[9187, 288, 66, 1, 70, "Command",
      CellTags->"EnterSubsession"],
    Cell[9256, 291, 192, 5, 70, "Usage",
      CellTags->"EnterSubsession"],
    Cell[9451, 298, 169, 6, 70, "Notes",
      CellTags->"EnterSubsession"],
    Cell[9623, 306, 239, 9, 70, "Notes",
      CellTags->"EnterSubsession"]},
  "ExitSubsession"->{
    Cell[9899, 320, 64, 1, 70, "Command",
      CellTags->"ExitSubsession"],
    Cell[9966, 323, 161, 5, 70, "Usage",
      CellTags->"ExitSubsession"]},
  "RemoveFromEvaluationQueue"->{
    Cell[10164, 333, 88, 1, 70, "Command",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[10255, 336, 204, 5, 70, "Usage",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[10462, 343, 300, 6, 70, "Notes",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[10765, 351, 187, 3, 70, "Notes",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[10955, 356, 312, 10, 70, "Notes",
      CellTags->"RemoveFromEvaluationQueue"]},
  "EvaluatorInterrupt"->{
    Cell[11316, 372, 99, 1, 70, "Command",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[11418, 375, 224, 5, 70, "Usage",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[11645, 382, 396, 7, 70, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12044, 391, 430, 12, 70, "Notes",
      CellTags->"EvaluatorInterrupt"],
    Cell[12477, 405, 140, 2, 70, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12620, 409, 156, 4, 70, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12779, 415, 108, 1, 70, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12890, 418, 434, 9, 70, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13327, 429, 137, 2, 70, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13467, 433, 357, 10, 70, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13827, 445, 181, 6, 70, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14011, 453, 251, 9, 70, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14265, 464, 452, 8, 70, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14720, 474, 480, 10, 70, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[15203, 486, 509, 17, 70, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[15715, 505, 496, 13, 50, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}]},
  "kernelInterruptID"->{
    Cell[11316, 372, 99, 1, 70, "Command",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[11418, 375, 224, 5, 70, "Usage",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[11645, 382, 396, 7, 70, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12477, 405, 140, 2, 70, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12620, 409, 156, 4, 70, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12779, 415, 108, 1, 70, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12890, 418, 434, 9, 70, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13327, 429, 137, 2, 70, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13467, 433, 357, 10, 70, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13827, 445, 181, 6, 70, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14011, 453, 251, 9, 70, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14265, 464, 452, 8, 70, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14720, 474, 480, 10, 70, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[15203, 486, 509, 17, 70, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[15715, 505, 496, 13, 50, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}]},
  "EvaluatorAbort"->{
    Cell[16248, 523, 65, 1, 34, "Command",
      CellTags->"EvaluatorAbort"],
    Cell[16316, 526, 159, 5, 29, "Usage",
      CellTags->"EvaluatorAbort"],
    Cell[16478, 533, 173, 3, 22, "Notes",
      CellTags->"EvaluatorAbort"],
    Cell[16654, 538, 172, 6, 22, "Notes",
      CellTags->"EvaluatorAbort"],
    Cell[16829, 546, 426, 12, 22, "Notes",
      CellTags->"EvaluatorAbort"]},
  "MenuListStartEvaluators"->{
    Cell[17292, 563, 70, 1, 34, "Command",
      CellTags->"MenuListStartEvaluators"],
    Cell[17365, 566, 162, 5, 29, "Usage",
      CellTags->"MenuListStartEvaluators"],
    Cell[17530, 573, 306, 6, 36, "Notes",
      CellTags->"MenuListStartEvaluators"]},
  "MenuListQuitEvaluators"->{
    Cell[17873, 584, 68, 1, 34, "Command",
      CellTags->"MenuListQuitEvaluators"],
    Cell[17944, 587, 164, 5, 29, "Usage",
      CellTags->"MenuListQuitEvaluators"],
    Cell[18111, 594, 305, 6, 36, "Notes",
      CellTags->"MenuListQuitEvaluators"],
    Cell[18419, 602, 141, 3, 22, "Notes",
      CellTags->"MenuListQuitEvaluators"]},
  "MenuListGlobalEvaluators"->{
    Cell[19379, 638, 73, 1, 34, "Command",
      CellTags->"MenuListGlobalEvaluators"],
    Cell[19455, 641, 201, 5, 29, "Usage",
      CellTags->"MenuListGlobalEvaluators"]},
  "MenuListNotebookEvaluators"->{
    Cell[19693, 651, 105, 1, 34, "Command",
      CellTags->"MenuListNotebookEvaluators"],
    Cell[19801, 654, 199, 5, 29, "Usage",
      CellTags->"MenuListNotebookEvaluators"]},
  "MenuListTerminals"->{
    Cell[20037, 664, 72, 1, 34, "Command",
      CellTags->"MenuListTerminals"],
    Cell[20112, 667, 199, 5, 29, "Usage",
      CellTags->"MenuListTerminals"],
    Cell[20314, 674, 342, 5, 56, "Notes",
      CellTags->"MenuListTerminals"]},
  "ModifyEvaluatorNames"->{
    Cell[20693, 684, 114, 1, 34, "Command",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[20810, 687, 242, 6, 29, "Usage",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[21055, 695, 288, 5, 36, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[21346, 702, 252, 4, 22, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[21623, 710, 165, 2, 38, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[21791, 714, 380, 9, 36, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[22174, 725, 173, 5, 22, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[22350, 732, 933, 27, 146, "ItemizedText",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[23332, 765, 160, 2, 28, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[23495, 769, 206, 5, 22, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[23704, 776, 792, 24, 154, "ItemizedText",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[24499, 802, 442, 10, 52, "NotesList",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[24966, 816, 106, 1, 32, "Subsubsection",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[25075, 819, 760, 13, 98, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[25872, 837, 130, 1, 32, "Subsubsection",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[26005, 840, 323, 6, 36, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[26331, 848, 195, 4, 22, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[26529, 854, 373, 10, 58, "ItemizedText",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[26905, 866, 178, 4, 24, "NotesList",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[27086, 872, 172, 4, 22, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[27261, 878, 878, 20, 138, "ItemizedText",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[28188, 904, 152, 2, 28, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[28365, 910, 147, 2, 32, "Subsubsection",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[28515, 914, 217, 5, 22, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[28735, 921, 621, 12, 64, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[29359, 935, 214, 5, 22, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[29576, 942, 3210, 80, 522, "ItemizedText",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[32811, 1026, 138, 2, 32, "Subsubsection",
      CellTags->{
      "enteringloginstring", "kernelSettingsDialogID", 
        "ModifyEvaluatorNames"}],
    Cell[32952, 1030, 335, 6, 36, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[33290, 1038, 283, 9, 22, "NotesList",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[33576, 1049, 206, 5, 22, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[33785, 1056, 2049, 59, 153, "Text",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[35837, 1117, 439, 11, 50, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[36279, 1130, 339, 11, 36, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[36621, 1143, 492, 11, 50, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[37162, 1160, 167, 3, 32, "Subsubsection",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[37332, 1165, 515, 10, 56, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[37850, 1177, 171, 3, 22, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[38024, 1182, 1799, 53, 312, "ItemizedText",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}]},
  "kernelSettingsDialogID"->{
    Cell[20693, 684, 114, 1, 34, "Command",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[20810, 687, 242, 6, 29, "Usage",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[21055, 695, 288, 5, 36, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[21346, 702, 252, 4, 22, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[21623, 710, 165, 2, 38, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[21791, 714, 380, 9, 36, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[22174, 725, 173, 5, 22, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[22350, 732, 933, 27, 146, "ItemizedText",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[23332, 765, 160, 2, 28, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[23495, 769, 206, 5, 22, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[23704, 776, 792, 24, 154, "ItemizedText",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[24499, 802, 442, 10, 52, "NotesList",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[24966, 816, 106, 1, 32, "Subsubsection",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[25075, 819, 760, 13, 98, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[25872, 837, 130, 1, 32, "Subsubsection",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[26005, 840, 323, 6, 36, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[26331, 848, 195, 4, 22, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[26529, 854, 373, 10, 58, "ItemizedText",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[26905, 866, 178, 4, 24, "NotesList",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[27086, 872, 172, 4, 22, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[27261, 878, 878, 20, 138, "ItemizedText",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[28188, 904, 152, 2, 28, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[28365, 910, 147, 2, 32, "Subsubsection",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[28515, 914, 217, 5, 22, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[28735, 921, 621, 12, 64, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[29359, 935, 214, 5, 22, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[29576, 942, 3210, 80, 522, "ItemizedText",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[32811, 1026, 138, 2, 32, "Subsubsection",
      CellTags->{
      "enteringloginstring", "kernelSettingsDialogID", 
        "ModifyEvaluatorNames"}],
    Cell[32952, 1030, 335, 6, 36, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[33290, 1038, 283, 9, 22, "NotesList",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[33576, 1049, 206, 5, 22, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[33785, 1056, 2049, 59, 153, "Text",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[35837, 1117, 439, 11, 50, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[36279, 1130, 339, 11, 36, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[36621, 1143, 492, 11, 50, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[37162, 1160, 167, 3, 32, "Subsubsection",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[37332, 1165, 515, 10, 56, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[37850, 1177, 171, 3, 22, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[38024, 1182, 1799, 53, 312, "ItemizedText",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}]},
  "enteringloginstring"->{
    Cell[32811, 1026, 138, 2, 32, "Subsubsection",
      CellTags->{
      "enteringloginstring", "kernelSettingsDialogID", 
        "ModifyEvaluatorNames"}]},
  "propertiesDialogID"->{
    Cell[39872, 1241, 62, 1, 24, "Command",
      CellTags->"propertiesDialogID"],
    Cell[39937, 1244, 148, 4, 29, "Usage",
      CellTags->"propertiesDialogID"],
    Cell[40088, 1250, 129, 3, 22, "Notes",
      CellTags->"propertiesDialogID"],
    Cell[40220, 1255, 59, 1, 25, "DialogItem",
      CellTags->"propertiesDialogID"],
    Cell[40282, 1258, 94, 1, 20, "IndentedText",
      CellTags->"propertiesDialogID"],
    Cell[40379, 1261, 62, 1, 25, "DialogItem",
      CellTags->"propertiesDialogID"],
    Cell[40444, 1264, 88, 1, 20, "IndentedText",
      CellTags->"propertiesDialogID"],
    Cell[40535, 1267, 61, 1, 25, "DialogItem",
      CellTags->"propertiesDialogID"],
    Cell[40599, 1270, 92, 1, 20, "IndentedText",
      CellTags->"propertiesDialogID"]},
  "ShowCellLabel"->{
    Cell[40728, 1276, 65, 1, 34, "Command",
      CellTags->"ShowCellLabel"],
    Cell[40796, 1279, 187, 7, 29, "Usage",
      CellTags->"ShowCellLabel"]},
  "DeleteGeneratedCells"->{
    Cell[41020, 1291, 72, 1, 34, "Command",
      CellTags->"DeleteGeneratedCells"],
    Cell[41095, 1294, 228, 6, 29, "Usage",
      CellTags->"DeleteGeneratedCells"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"EvaluateCells", 42064, 1324},
  {"Evaluate", 42456, 1335},
  {"EvaluateNextCell", 42764, 1344},
  {"SubsessionEvaluateCells", 43188, 1355},
  {"SubsessionEvaluateCell", 43645, 1366},
  {"EvaluateNotebook", 43755, 1369},
  {"EvaluateInitialization", 44021, 1376},
  {"EnterSubsession", 44298, 1383},
  {"ExitSubsession", 44630, 1392},
  {"RemoveFromEvaluationQueue", 44817, 1397},
  {"EvaluatorInterrupt", 45286, 1408},
  {"kernelInterruptID", 47009, 1441},
  {"EvaluatorAbort", 48647, 1472},
  {"MenuListStartEvaluators", 49066, 1483},
  {"MenuListQuitEvaluators", 49356, 1490},
  {"MenuListGlobalEvaluators", 49730, 1499},
  {"MenuListNotebookEvaluators", 49940, 1504},
  {"MenuListTerminals", 50146, 1509},
  {"ModifyEvaluatorNames", 50416, 1516},
  {"kernelSettingsDialogID", 54972, 1597},
  {"enteringloginstring", 59525, 1678},
  {"propertiesDialogID", 59711, 1683},
  {"ShowCellLabel", 60502, 1702},
  {"DeleteGeneratedCells", 60686, 1707}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 94, 4, 54, "Section"],

Cell[CellGroupData[{
Cell[1850, 59, 62, 1, 34, "Command",
  CellTags->"EvaluateCells"],
Cell[1915, 62, 190, 5, 29, "Usage",
  CellTags->"EvaluateCells"],
Cell[2108, 69, 784, 13, 132, "Notes",
  CellTags->"EvaluateCells"],
Cell[2895, 84, 564, 17, 36, "Notes",
  CellTags->"EvaluateCells"]
}, Open  ]],
Cell[3474, 104, 168, 3, 22, "Notes",
  CellTags->"EvaluateCells"],

Cell[CellGroupData[{
Cell[3667, 111, 60, 1, 34, "Command",
  CellTags->"Evaluate"],
Cell[3730, 114, 165, 5, 29, "Usage",
  CellTags->"Evaluate"],
Cell[3898, 121, 565, 13, 76, "Notes",
  CellTags->"Evaluate"],
Cell[4466, 136, 434, 12, 70, "Notes",
  CellTags->"Evaluate"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4937, 153, 70, 1, 70, "Command",
  CellTags->"EvaluateNextCell"],
Cell[5010, 156, 191, 5, 70, "Usage",
  CellTags->"EvaluateNextCell"],
Cell[5204, 163, 423, 6, 70, "Notes",
  CellTags->"EvaluateNextCell"],
Cell[5630, 171, 290, 5, 70, "Notes",
  CellTags->"EvaluateNextCell"],
Cell[5923, 178, 433, 12, 70, "Notes",
  CellTags->"EvaluateNextCell"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6393, 195, 80, 1, 70, "Command",
  CellTags->"SubsessionEvaluateCells"],
Cell[6476, 198, 192, 5, 70, "Usage",
  CellTags->"SubsessionEvaluateCells"],
Cell[6671, 205, 476, 9, 70, "Notes",
  CellTags->"SubsessionEvaluateCells"],
Cell[7150, 216, 189, 3, 70, "Notes",
  CellTags->"SubsessionEvaluateCells"],
Cell[7342, 221, 177, 6, 70, "Notes",
  CellTags->"SubsessionEvaluateCells"],
Cell[7522, 229, 429, 12, 70, "Notes",
  CellTags->"SubsessionEvaluateCell"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7988, 246, 68, 1, 70, "Command",
  CellTags->"EvaluateNotebook"],
Cell[8059, 249, 184, 5, 70, "Usage",
  CellTags->"EvaluateNotebook"],
Cell[8246, 256, 217, 4, 70, "Notes",
  CellTags->"EvaluateNotebook"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8500, 265, 80, 1, 70, "Command",
  CellTags->"EvaluateInitialization"],
Cell[8583, 268, 195, 5, 70, "Usage",
  CellTags->"EvaluateInitialization"],
Cell[8781, 275, 369, 8, 70, "Notes",
  CellTags->"EvaluateInitialization"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9187, 288, 66, 1, 70, "Command",
  CellTags->"EnterSubsession"],
Cell[9256, 291, 192, 5, 70, "Usage",
  CellTags->"EnterSubsession"],
Cell[9451, 298, 169, 6, 70, "Notes",
  CellTags->"EnterSubsession"],
Cell[9623, 306, 239, 9, 70, "Notes",
  CellTags->"EnterSubsession"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9899, 320, 64, 1, 70, "Command",
  CellTags->"ExitSubsession"],
Cell[9966, 323, 161, 5, 70, "Usage",
  CellTags->"ExitSubsession"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10164, 333, 88, 1, 70, "Command",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[10255, 336, 204, 5, 70, "Usage",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[10462, 343, 300, 6, 70, "Notes",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[10765, 351, 187, 3, 70, "Notes",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[10955, 356, 312, 10, 70, "Notes",
  CellTags->"RemoveFromEvaluationQueue"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11316, 372, 99, 1, 70, "Command",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[11418, 375, 224, 5, 70, "Usage",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[11645, 382, 396, 7, 70, "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[12044, 391, 430, 12, 70, "Notes",
  CellTags->"EvaluatorInterrupt"],
Cell[12477, 405, 140, 2, 70, "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[12620, 409, 156, 4, 70, "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[12779, 415, 108, 1, 70, "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[12890, 418, 434, 9, 70, "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[13327, 429, 137, 2, 70, "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[13467, 433, 357, 10, 70, "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[13827, 445, 181, 6, 70, "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[14011, 453, 251, 9, 70, "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[14265, 464, 452, 8, 70, "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[14720, 474, 480, 10, 70, "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[15203, 486, 509, 17, 70, "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[15715, 505, 496, 13, 50, "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16248, 523, 65, 1, 34, "Command",
  CellTags->"EvaluatorAbort"],
Cell[16316, 526, 159, 5, 29, "Usage",
  CellTags->"EvaluatorAbort"],
Cell[16478, 533, 173, 3, 22, "Notes",
  CellTags->"EvaluatorAbort"],
Cell[16654, 538, 172, 6, 22, "Notes",
  CellTags->"EvaluatorAbort"],
Cell[16829, 546, 426, 12, 22, "Notes",
  CellTags->"EvaluatorAbort"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17292, 563, 70, 1, 34, "Command",
  CellTags->"MenuListStartEvaluators"],
Cell[17365, 566, 162, 5, 29, "Usage",
  CellTags->"MenuListStartEvaluators"],
Cell[17530, 573, 306, 6, 36, "Notes",
  CellTags->"MenuListStartEvaluators"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17873, 584, 68, 1, 34, "Command",
  CellTags->"MenuListQuitEvaluators"],
Cell[17944, 587, 164, 5, 29, "Usage",
  CellTags->"MenuListQuitEvaluators"],
Cell[18111, 594, 305, 6, 36, "Notes",
  CellTags->"MenuListQuitEvaluators"],
Cell[18419, 602, 141, 3, 22, "Notes",
  CellTags->"MenuListQuitEvaluators"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18597, 610, 116, 2, 34, "Command"],
Cell[18716, 614, 190, 3, 29, "Usage"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18943, 622, 117, 2, 34, "Command"],
Cell[19063, 626, 279, 7, 43, "Usage"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19379, 638, 73, 1, 34, "Command",
  CellTags->"MenuListGlobalEvaluators"],
Cell[19455, 641, 201, 5, 29, "Usage",
  CellTags->"MenuListGlobalEvaluators"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19693, 651, 105, 1, 34, "Command",
  CellTags->"MenuListNotebookEvaluators"],
Cell[19801, 654, 199, 5, 29, "Usage",
  CellTags->"MenuListNotebookEvaluators"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20037, 664, 72, 1, 34, "Command",
  CellTags->"MenuListTerminals"],
Cell[20112, 667, 199, 5, 29, "Usage",
  CellTags->"MenuListTerminals"],
Cell[20314, 674, 342, 5, 56, "Notes",
  CellTags->"MenuListTerminals"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20693, 684, 114, 1, 34, "Command",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[20810, 687, 242, 6, 29, "Usage",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[21055, 695, 288, 5, 36, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[21346, 702, 252, 4, 22, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[CellGroupData[{
Cell[21623, 710, 165, 2, 38, "SubsectionIcon",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[21791, 714, 380, 9, 36, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[22174, 725, 173, 5, 22, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[22350, 732, 933, 27, 146, "ItemizedText",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[23332, 765, 160, 2, 28, "SubsectionIcon",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[23495, 769, 206, 5, 22, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[23704, 776, 792, 24, 154, "ItemizedText",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[24499, 802, 442, 10, 52, "NotesList",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[CellGroupData[{
Cell[24966, 816, 106, 1, 32, "Subsubsection",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[25075, 819, 760, 13, 98, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[25872, 837, 130, 1, 32, "Subsubsection",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[26005, 840, 323, 6, 36, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[26331, 848, 195, 4, 22, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[26529, 854, 373, 10, 58, "ItemizedText",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[26905, 866, 178, 4, 24, "NotesList",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[27086, 872, 172, 4, 22, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[27261, 878, 878, 20, 138, "ItemizedText",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[28188, 904, 152, 2, 28, "SubsectionIcon",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[CellGroupData[{
Cell[28365, 910, 147, 2, 32, "Subsubsection",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[28515, 914, 217, 5, 22, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[28735, 921, 621, 12, 64, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[29359, 935, 214, 5, 22, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[29576, 942, 3210, 80, 522, "ItemizedText",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[CellGroupData[{
Cell[32811, 1026, 138, 2, 32, "Subsubsection",
  CellTags->{
  "enteringloginstring", "kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[32952, 1030, 335, 6, 36, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[33290, 1038, 283, 9, 22, "NotesList",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[33576, 1049, 206, 5, 22, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[33785, 1056, 2049, 59, 153, "Text",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[35837, 1117, 439, 11, 50, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[36279, 1130, 339, 11, 36, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[36621, 1143, 492, 11, 50, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37162, 1160, 167, 3, 32, "Subsubsection",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[37332, 1165, 515, 10, 56, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[37850, 1177, 171, 3, 22, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[38024, 1182, 1799, 53, 312, "ItemizedText",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[39872, 1241, 62, 1, 24, "Command",
  CellTags->"propertiesDialogID"],
Cell[39937, 1244, 148, 4, 29, "Usage",
  CellTags->"propertiesDialogID"],
Cell[40088, 1250, 129, 3, 22, "Notes",
  CellTags->"propertiesDialogID"],
Cell[40220, 1255, 59, 1, 25, "DialogItem",
  CellTags->"propertiesDialogID"],
Cell[40282, 1258, 94, 1, 20, "IndentedText",
  CellTags->"propertiesDialogID"],
Cell[40379, 1261, 62, 1, 25, "DialogItem",
  CellTags->"propertiesDialogID"],
Cell[40444, 1264, 88, 1, 20, "IndentedText",
  CellTags->"propertiesDialogID"],
Cell[40535, 1267, 61, 1, 25, "DialogItem",
  CellTags->"propertiesDialogID"],
Cell[40599, 1270, 92, 1, 20, "IndentedText",
  CellTags->"propertiesDialogID"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40728, 1276, 65, 1, 34, "Command",
  CellTags->"ShowCellLabel"],
Cell[40796, 1279, 187, 7, 29, "Usage",
  CellTags->"ShowCellLabel"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41020, 1291, 72, 1, 34, "Command",
  CellTags->"DeleteGeneratedCells"],
Cell[41095, 1294, 228, 6, 29, "Usage",
  CellTags->"DeleteGeneratedCells"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

